/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class BlockTagCondition
implements Condition<BlockState> {
    private final HolderSet.Named<Block> entries;

    private BlockTagCondition(HolderSet.Named<Block> entries) {
        this.entries = entries;
    }

    public static ConditionFactory<BlockState> factory() {
        return ConditionFactory.withData(BlockTagCondition::parse);
    }

    public static Result<BlockTagCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(BlockTagCondition::parse);
    }

    public static Result<BlockTagCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTag = rootObject.get("tag").andThen(JsonParseUtils::parseBlockTag).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new BlockTagCondition((HolderSet.Named<Block>)((HolderSet.Named)optTag.orElseThrow())));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(BlockState blockState) {
        return blockState.m_204341_(this.entries);
    }
}

